/* vmop.t - main Sxeme opcodes table */

/* signatures */
OPSIG(RANGE07)        /* no parameters (SREF0, PUSHSREF0)*/
OPSIG(NONE)           /* no parameters */
OPSIG(BYTE)           /* 1-byte parameter */
OPSIG(DVAR)           /* 1-byte DVAR index */
OPSIG(LITB)           /* 1-byte LITB parameter */
OPSIG(LITREF)         /* 1-byte litvec index */
OPSIG(GCELLREF)       /* 1-byte litvec index of gcell */
OPSIG(CODEREF)        /* 1-byte litvec index of code */
OPSIG(BYTE_CODEREF)   /* 1-byte parameter and 1-byte litvec index of code */
OPSIG(ADDR)           /* 2-byte address */
OPSIG(BYTE_BYTE)      /* 2 1-byte parameters */
OPSIG(BYTE_ADDR)      /* 1-byte parameter and 2-byte address */
OPSIG(BYTE_BYTE_ADDR) /* 2 1-byte parameters and 2-byte address */
OPSIG(FRAME_INDEX)    /* 1-byte frame number and 1-byte frame index */
OPSIG(INDEX)          /* 1-byte frame index */
OPSIG(EFRAME_VARSREF) /* 1-byte frame size and 1-byte litvec index of vars */
OPSIG(TAG)            /* 1-byte node tag */
OPSIG(TAG_ADDR)       /* 1-byte node tag and and 2-byte address */
OPSIG(STOP)           /* no parameters (CURRY, PORTOP) */
OPSIG(LITREF_ADDR)    /* 1-byte litvec index and 2-byte address */

/* opcodes */
OPCODE(SREF0,        0x10,      RANGE07)
OPCODE(PUSHSREF0,    0x18,      RANGE07)
OPCODE(POP,          0x20,      NONE)
OPCODE(EFRAME,       0x21,      EFRAME_VARSREF)
OPCODE(MVARGS,       0x22,      BYTE)
OPCODE(MVOARG,       0x23,      INDEX)
OPCODE(MVRARG,       0x24,      INDEX)
OPCODE(SHOARG,       0x25,      BYTE)
OPCODE(SHRARG,       0x26,      BYTE)
OPCODE(PUSHEREF,     0x27,      FRAME_INDEX)
OPCODE(ATEST,        0x28,      BYTE)
OPCODE(ADROP,        0x29,      BYTE)
OPCODE(ALAST,        0x2A,      NONE)
OPCODE(BRT,          0x2B,      ADDR)
OPCODE(BRNOT,        0x2C,      ADDR)
OPCODE(BR,           0x2D,      ADDR)
OPCODE(LIT,          0x2E,      LITREF)
OPCODE(GREF,         0x2F,      GCELLREF)
OPCODE(GSET,         0x30,      GCELLREF)
OPCODE(EREF,         0x31,      FRAME_INDEX)
OPCODE(ESET,         0x32,      FRAME_INDEX)
OPCODE(SREF,         0x33,      BYTE)
OPCODE(DREF,         0x34,      DVAR)
OPCODE(MEMV,         0x35,      NONE)
OPCODE(BRMEMV,       0x36,      ADDR)
OPCODE(SAVE,         0x37,      ADDR)
OPCODE(CALL,         0x38,      BYTE)
OPCODE(RETURN,       0x39,      NONE)
OPCODE(SCALL,        0x3A,      BYTE_BYTE)
OPCODE(SRETURN,      0x3B,      BYTE)
OPCODE(PUSH,         0x3C,      NONE)
OPCODE(CLOSE,        0x3D,      CODEREF)
OPCODE(T,            0x3E,      NONE)
OPCODE(F,            0x3F,      NONE)
OPCODE(NIL,          0x40,      NONE)
OPCODE(MKPROMISE,    0x41,      NONE)
OPCODE(ATOM,         0x42,      NONE)
OPCODE(EQ,           0x43,      NONE)
OPCODE(NULL,         0x44,      NONE)
OPCODE(NOT,          0x45,      NONE)
OPCODE(CONS,         0x46,      NONE)
OPCODE(CAR,          0x47,      NONE)
OPCODE(CDR,          0x48,      NONE)
OPCODE(SETCAR,       0x49,      NONE)
OPCODE(SETCDR,       0x4A,      NONE)
OPCODE(ADD,          0x4B,      NONE)
OPCODE(SUB,          0x4C,      NONE)
OPCODE(MUL,          0x4D,      NONE)
OPCODE(QUO,          0x4E,      NONE)
OPCODE(INC,          0x4F,      NONE)
OPCODE(DEC,          0x50,      NONE)
OPCODE(LT,           0x51,      NONE)
OPCODE(EQL,          0x52,      NONE)
OPCODE(GT,           0x53,      NONE)
OPCODE(DEFAULT,      0x54,      NONE)
OPCODE(OMITTED,      0x55,      NONE)
OPCODE(AERROR,       0x56,      BYTE)
OPCODE(EDROP,        0x57,      NONE)
OPCODE(ACNT,         0x58,      BYTE)
OPCODE(DCLOSE,       0x59,      BYTE_CODEREF)
OPCODE(SHIFT,        0x5A,      BYTE_BYTE)
OPCODE(PUSHDEF,      0x5B,      NONE)
OPCODE(PUSHNIL,      0x5C,      NONE)
OPCODE(PAIR,         0x5D,      NONE)
OPCODE(MEMQ,         0x5E,      NONE)
OPCODE(PUSHT,        0x5F,      NONE)
OPCODE(PUSHF,        0x60,      NONE)
OPCODE(PUSHLIT,      0x61,      LITREF)
OPCODE(PUSHSREF,     0x62,      BYTE)
OPCODE(PUSHCONS,     0x63,      NONE)
OPCODE(PUSHCAR,      0x64,      NONE)
OPCODE(PUSHCDR,      0x65,      NONE)
OPCODE(PUSHADD,      0x66,      NONE)
OPCODE(PUSHSUB,      0x67,      NONE)
OPCODE(PUSHMUL,      0x68,      NONE)
OPCODE(PUSHQUO,      0x69,      NONE)
OPCODE(PUSHINC,      0x6A,      NONE)
OPCODE(PUSHDEC,      0x6B,      NONE)
OPCODE(PUSHMEMQ,     0x6C,      NONE)
OPCODE(PUSHMKPROM,   0x6D,      NONE)
OPCODE(BRSREF,       0x6E,      BYTE_ADDR)
OPCODE(BRATOM,       0x6F,      ADDR)
OPCODE(BRPAIR,       0x70,      ADDR)
OPCODE(BREQ,         0x71,      ADDR)
OPCODE(BRNULL,       0x72,      ADDR)
OPCODE(BRLT,         0x73,      ADDR)
OPCODE(BREQL,        0x74,      ADDR)
OPCODE(BRGT,         0x75,      ADDR)
OPCODE(BRMEMQ,       0x76,      ADDR)
OPCODE(BROMITTED,    0x77,      ADDR)
OPCODE(BSB,          0x78,      BYTE_ADDR)
OPCODE(SBSB,         0x79,      BYTE_BYTE_ADDR)
OPCODE(LITB,         0x7A,      LITB)
OPCODE(PUSHLITB,     0x7B,      LITB)
OPCODE(LIST,         0x7C,      BYTE)
OPCODE(PUSHLIST,     0x7D,      BYTE)
OPCODE(EQLIT,        0x7E,      LITREF)
OPCODE(BREQLIT,      0x7F,      LITREF_ADDR)
OPCODE(MVC,          0x80,      NONE)
OPCODE(SMVC,         0x81,      BYTE)
OPCODE(PORTOP,       0x82,      STOP)
OPCODE(RESTORE,      0x83,      STOP)
OPCODE(PUSHMEMV,     0x84,      NONE)
OPCODE(TYPEP,        0x85,      TAG)
OPCODE(BRTYPEP,      0x86,      TAG_ADDR)
OPCODE(VREF,         0x87,      NONE)
OPCODE(PUSHVREF,     0x88,      NONE)
OPCODE(VSET,         0x89,      NONE)
OPCODE(VSIZE,        0x8A,      NONE)
OPCODE(ILIST,        0x8B,      BYTE)
OPCODE(PUSHILIST,    0x8C,      BYTE)
OPCODE(CURRY,        0x8D,      STOP)
OPCODE(ZERO,         0x8E,      NONE)
OPCODE(BRZERO,       0x8F,      ADDR)
OPCODE(SBOX,         0x90,      BYTE)
OPCODE(DROP,         0x91,      BYTE)
OPCODE(SREFI,        0x92,      BYTE)
OPCODE(SSETI,        0x93,      BYTE)
OPCODE(DREFI,        0x94,      DVAR)
OPCODE(DSETI,        0x95,      DVAR)
OPCODE(STRREF,       0x96,      NONE)
OPCODE(PUSHSTRREF,   0x97,      NONE)
OPCODE(STRSET,       0x98,      NONE)
OPCODE(STRSIZE,      0x99,      NONE)
OPCODE(SHAUXARG,     0x9A,      NONE)


